<?xml version="1.0" encoding="UTF-8"?>
<!-- El objetivo de este archivo SLD, es el de simbolizar la entidad urbanística correspondiente según lo indicado en la "Instrucción técnica de estandarización y normalización de instrumentos de planeamiento (ITU-PL1)". Antes de su uso deberá revisar las etiquetas que hacen referencia a los campos existentes en las tablas de datos, especialmente los destinados a simbolizar por categorías, los de elementos alfanuméricos y los de geometría. Su definición puede admitir variantes y ser mejorada. Si es el caso, por favor, comparta su conocimiento para que futuros usuarios puedan beneficiarse. Gracias. | Murcia, mayo de 2024 | SERVICIO DE URBANISMO | https://www.urbmurcia.es/web/urbmurcia/contacto | -->
<sld:StyledLayerDescriptor xmlns="http://www.opengis.net/sld" xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" xmlns:gml="http://www.opengis.net/gml" version="1.0.0">
	<sld:NamedLayer>
		<sld:Name>06_cat_urbanizable</sld:Name>
		<sld:UserStyle>
			<sld:Name>06_cat_urbanizable</sld:Name>
			<sld:FeatureTypeStyle>
				<sld:Name>linea</sld:Name>
				<sld:Title>Categorías de suelo urbanizable</sld:Title>
				<sld:Abstract/>
				<sld:Rule>
					<sld:Name>linea</sld:Name>
					<sld:Title>Categoría suelo urbanizable</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>25000.0</sld:MaxScaleDenominator> -->
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#8C145A</sld:CssParameter>
							<sld:CssParameter name="stroke-width">1.5</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">10.0 3.0 2.0 3.0 2.0 3.0</sld:CssParameter>
						</sld:Stroke>
						<sld:PerpendicularOffset>0.0</sld:PerpendicularOffset>
					</sld:LineSymbolizer>
				</sld:Rule>
			</sld:FeatureTypeStyle>
			<sld:FeatureTypeStyle>
				<sld:Name>poligono</sld:Name>
				<sld:Title/>
				<sld:Abstract/>
				<sld:Rule>
					<sld:Name>Código</sld:Name>
					<sld:Title/>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>25000.0</sld:MaxScaleDenominator> -->
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Código</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">12</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>0.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#8C145A</sld:CssParameter>
						</sld:Fill>
						<sld:VendorOption name="repeat">1</sld:VendorOption>
						<sld:VendorOption name="partials">true</sld:VendorOption>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>ZZ</sld:Name>
					<sld:Title>(ZZ) Sectorizado</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>ZZ</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>25000.0</sld:MaxScaleDenominator> -->
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
						<sld:Fill>
							<sld:GraphicFill>
								<sld:Graphic>
									<sld:Mark>
										<sld:WellKnownName>shape://times</sld:WellKnownName>
										<sld:Stroke>
											<sld:CssParameter name="stroke">#333333</sld:CssParameter>
										</sld:Stroke>
									</sld:Mark>
									<sld:Size>13.0</sld:Size>
									<sld:Rotation>45.0</sld:Rotation>
								</sld:Graphic>
							</sld:GraphicFill>
						</sld:Fill>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>ZS</sld:Name>
					<sld:Title>(ZS) Sin sectorizar</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>ZS</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>25000.0</sld:MaxScaleDenominator> -->
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
						<sld:Fill>
							<sld:GraphicFill>
								<sld:Graphic>
									<sld:Mark>
										<sld:WellKnownName>shape://times</sld:WellKnownName>
										<sld:Stroke>
											<sld:CssParameter name="stroke">#333333</sld:CssParameter>
										</sld:Stroke>
									</sld:Mark>
									<sld:Size>16.0</sld:Size>
								</sld:Graphic>
							</sld:GraphicFill>
						</sld:Fill>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>ZE-Z</sld:Name>
					<sld:Title>(ZE-Z) Especial sectorizado</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>ZE-E</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>25000.0</sld:MaxScaleDenominator> -->
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
						<sld:Fill>
							<sld:GraphicFill>
								<sld:Graphic>
									<sld:Mark>
										<sld:WellKnownName>shape://times</sld:WellKnownName>
										<sld:Stroke>
											<sld:CssParameter name="stroke">#333333</sld:CssParameter>
										</sld:Stroke>
									</sld:Mark>
									<sld:Size>13.0</sld:Size>
									<sld:Rotation>45.0</sld:Rotation>
								</sld:Graphic>
							</sld:GraphicFill>
						</sld:Fill>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>ZE-S</sld:Name>
					<sld:Title>(ZE-S) Especial sin sectorizar</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>ZE-S</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>25000.0</sld:MaxScaleDenominator> -->
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
						<sld:Fill>
							<sld:GraphicFill>
								<sld:Graphic>
									<sld:Mark>
										<sld:WellKnownName>shape://times</sld:WellKnownName>
										<sld:Stroke>
											<sld:CssParameter name="stroke">#333333</sld:CssParameter>
										</sld:Stroke>
									</sld:Mark>
									<sld:Size>16.0</sld:Size>
								</sld:Graphic>
							</sld:GraphicFill>
						</sld:Fill>
					</sld:PolygonSymbolizer>
				</sld:Rule>
			</sld:FeatureTypeStyle>
		</sld:UserStyle>
	</sld:NamedLayer>
</sld:StyledLayerDescriptor>